/*  Fügt für den gegebenen AG einen neuen Eintrag in die Tabelle resource_requirement_option mit der gegebenen Ressourcen-ID hinzu.

    Dabei werden eventuell fehlende Eintragungen in der Tabelle resource_requirement nachgeholt. Ebenfalls werden vorhandene
    Kopfkostenstellen beachtet und ggf. für diese auch ein Eintrag in der Tabelle resource_requirement_option vorgenommen.

    Auch wird geprüft, ob die zu erstellende Resource-Option bereits existiert und ggf. nur die Spalte load aktualisiert.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__resource_requirement_options__add_option', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__resource_requirement_options__add_option(
      _ab2_id int,
      _resource_id int,
      _requirement_id int = null,
      _load numeric = 1,
      _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
  ) RETURNS boolean AS $$
  DECLARE

      _context text :=
          context
          FROM scheduling.resource
          WHERE id = _resource_id;

      _ab2_resource_id int := id FROM scheduling.resource WHERE context = 'ab2' and context_id = _ab2_id;

      _ks_top_ksabt varchar(9) :=
          ks_top_ksabt
          FROM ksv
          WHERE ks_id = ( SELECT ksb_ks_id
                            FROM scheduling.resource__translate__resource_id__to__ksvba__shorthand( _resource_id ) );

      _top_requirement_id int;

      _top_resource_id int;

  BEGIN

      -- Sind die übgergbenen Parameter gültig?
      IF (
            _ab2_id IS NULL
        OR _resource_id IS NULL
        OR _load    IS NULL
        OR _load > 1
        OR _load < 0
      ) THEN
          RAISE EXCEPTION 'invalid parameter: _ab2_id: %, _resource_id: %, _load: %', _ab2_id, _resource_id, _load;
      END IF;

      -- Gibt es die Zielressource?
      IF ( _context IS NULL ) THEN
          RAISE EXCEPTION 'non-existing resource-id in scheduling.resource(id): %', _resource_id;
      END IF;

      -- if requirement is not specified, we try to autodetect it
      IF _requirement_id IS NULL THEN
          _requirement_id :=
              id
              FROM scheduling.resource_requirement
              WHERE     required_by = _ab2_resource_id
                    AND context = _context
              LIMIT 1;
      END IF;

      -- still null, create new resource_requirement
      IF _requirement_id IS NULL THEN
          INSERT INTO scheduling.resource_requirement ( required_by, context )
          VALUES ( _ab2_resource_id, _context )
          RETURNING id INTO _requirement_id;
      END IF;

      -- Die Ressource-Option fehlt noch, dann ...
      IF NOT EXISTS (
                      SELECT id
                        FROM scheduling.resource_requirement_option
                       WHERE requirement_id = _requirement_id
                         AND resource_id = _resource_id
                    )
      THEN
          -- ... die neue Ressource-Option anlegen.
          INSERT INTO scheduling.resource_requirement_option ( requirement_id, resource_id, load )
          VALUES ( _requirement_id, _resource_id, _load );
      ELSE
          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE 'resource option already exists';
          END IF;

          -- Load in der vorhandenen Ressource-Option aktualisieren.
          UPDATE scheduling.resource_requirement_option
             SET load = _load
           WHERE requirement_id = _requirement_id
             AND resource_id = _resource_id
             AND load IS DISTINCT FROM _load;
      END IF;

      -- Füge ggf. Kopfkostenstellen bzw. Nebenressourcen als Abhängigkeiten hinzu.
      IF _ks_top_ksabt IS NOT NULL THEN

          RAISE NOTICE 'ksv top: %', _ks_top_ksabt;

          -- Versuche die Abhängigkeit zur Kopfkostenstelle zu ermitteln.

          _top_requirement_id :=
              id
              FROM scheduling.resource_requirement
              WHERE     required_by = _resource_id
                    AND context = 'ksvba'
              LIMIT 1;

          -- Keine Abhängigkeit zur Kopfkostenstelle gefunden, daher jetzt anlegen.

          IF _top_requirement_id IS NULL THEN
              INSERT INTO scheduling.resource_requirement ( required_by, context )
              VALUES ( _resource_id, 'ksvba' )

              RETURNING id INTO _top_requirement_id;
          END IF;

          -- Lösche eventuell bestehende Ressourcen-Option zur Kopfkostenstelle.
          DELETE FROM scheduling.resource_requirement_option
          WHERE requirement_id = _top_requirement_id;

          -- Ermittle die resource_id der Kopfkostenstelle
          SELECT scheduling.resource.id
          INTO _top_resource_id
          FROM ksvba
          JOIN scheduling.resource ON context_id = ksvba.ksb_id AND context = 'ksvba'
          WHERE ksb_ks_abt = _ks_top_ksabt
                AND ksb_ks_ba_num = 1;

          -- Schreibe die Ressourcen-Option zur Kopfkostenstelle.
          INSERT INTO scheduling.resource_requirement_option ( requirement_id, resource_id, load )
          VALUES ( _top_requirement_id, _top_resource_id , 1 ); -- TODO AXS: Anderen Wert als 1 für load verwenden. Überlegen, was sinnvoll wäre.

      END IF;

      RETURN true;

  END $$ LANGUAGE plpgsql;